

<?php $__env->startSection('title', 'View Prescription'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="mb-4 sm:mb-6 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">Prescription Details</h1>
        <a href="<?php echo e(auth()->user()->isDoctor() ? route('doctor.dashboard') : (auth()->user()->isAdmin() ? route('admin.dashboard') : (auth()->user()->isPharmacist() ? route('pharmacist.dashboard') : route('patient.dashboard')))); ?>" 
           class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
            <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
        </a>
    </div>

    <div class="bg-white rounded-lg shadow p-4 sm:p-6 mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 gap-3">
            <h2 class="text-lg sm:text-xl font-bold">Prescription #<?php echo e($prescription->prescription_number); ?></h2>
            <a href="<?php echo e(route('prescriptions.download', $prescription->id)); ?>" 
               class="bg-blue-600 hover:bg-blue-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base w-full sm:w-auto text-center">
                <i class="fas fa-download"></i> Download PDF
            </a>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mb-4 sm:mb-6">
            <div>
                <strong>Patient:</strong> <?php echo e($prescription->patient->full_name); ?>

            </div>
            <div>
                <strong>Patient ID:</strong> <?php echo e($prescription->patient->patient_id); ?>

            </div>
            <div>
                <strong>Doctor:</strong> <?php echo e($prescription->doctor->full_name); ?>

            </div>
            <div>
                <strong>Date:</strong> <?php echo e($prescription->created_at->format('M d, Y')); ?>

            </div>
        </div>

        <?php if($prescription->diagnosis): ?>
        <div class="mb-6">
            <strong>Diagnosis:</strong> <?php echo e($prescription->diagnosis); ?>

        </div>
        <?php endif; ?>

        <div class="mb-4 sm:mb-6">
            <h3 class="text-base sm:text-lg font-bold mb-3 sm:mb-4">Prescription Items</h3>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">#</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Medicine</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden md:table-cell">Dosage</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Frequency</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase hidden lg:table-cell">Instructions</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Duration</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $prescription->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap text-sm"><?php echo e($item->item_number); ?></td>
                        <td class="px-3 sm:px-6 py-4 text-sm sm:text-base"><?php echo e($item->medicine_name); ?></td>
                        <td class="px-3 sm:px-6 py-4 hidden md:table-cell text-sm"><?php echo e($item->dosage); ?></td>
                        <td class="px-3 sm:px-6 py-4 text-sm"><?php echo e($item->frequency); ?></td>
                        <td class="px-3 sm:px-6 py-4 hidden lg:table-cell text-sm"><?php echo e($item->instructions ?? 'N/A'); ?></td>
                        <td class="px-3 sm:px-6 py-4 text-sm"><?php echo e($item->duration); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            </div>
        </div>

        <?php if($prescription->additional_prescription_details): ?>
        <div class="mb-6">
            <strong>Additional Details:</strong>
            <p><?php echo e($prescription->additional_prescription_details); ?></p>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/prescriptions/show.blade.php ENDPATH**/ ?>